/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.client.internal;

import java.io.Closeable;
import net.impactdev.impactor.relocations.com.mongodb.ClientEncryptionSettings;
import net.impactdev.impactor.relocations.com.mongodb.MongoNamespace;
import net.impactdev.impactor.relocations.com.mongodb.WriteConcern;
import net.impactdev.impactor.relocations.com.mongodb.client.MongoClient;
import net.impactdev.impactor.relocations.com.mongodb.client.MongoClients;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.Crypt;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.Crypts;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.SimpleMongoClients;
import net.impactdev.impactor.relocations.com.mongodb.client.model.vault.DataKeyOptions;
import net.impactdev.impactor.relocations.com.mongodb.client.model.vault.EncryptOptions;
import net.impactdev.impactor.relocations.com.mongodb.client.vault.ClientEncryption;
import net.impactdev.impactor.relocations.org.bson.BsonBinary;
import net.impactdev.impactor.relocations.org.bson.BsonDocument;
import net.impactdev.impactor.relocations.org.bson.BsonValue;

public class ClientEncryptionImpl
implements ClientEncryption,
Closeable {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = MongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(SimpleMongoClients.create(this.keyVaultClient), options);
        this.options = options;
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions);
        MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
        this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }
}

